<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = htmlspecialchars(trim($_POST['email']));
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        die("Invalid email");
    }

    // Load the template (stored as template.html on the server)
    $template = file_get_contents('news.html');

    // Replace placeholder
    $filledTemplate = str_replace('{{EMAIL}}', $email, $template);

    // Optional: create filename based on email
    $filename = 'saved_templates/' . preg_replace('/[^a-zA-Z0-9]/', '_', $email) . '.html';

    // Save to server
    file_put_contents($filename, $filledTemplate);

    echo "File saved as: <a href='$filename' target='_blank'>$filename</a>";
} else {
    echo "No data submitted.";
}
?>
